with base as
(
  select
    topic,
    subtopic,
    format,
    subformat
  from metadata.atlas_f_event_broadcast_channel
  group by
    topic,
    subtopic,
    format,
    subformat
),
data as
(
  select
    'topic' as content_type,
     topic as content_data
  from base
  group by
    topic
    
  union all

  select
    'subtopic' as content_type,
    trim(substring(subtopic, length(subtopic) - strpos(reverse(subtopic), '|')+2)) as content_data
  from base
  group by
    trim(substring(subtopic, length(subtopic) - strpos(reverse(subtopic), '|')+2))
  
  union all

  select
    'format' as content_type,
    trim(substring(format, length(format) - strpos(reverse(format), '|')+2)) as content_data
  from base
  group by
    trim(substring(format, length(format) - strpos(reverse(format), '|')+2))

  union all

  select
    'subformat' as content_type,
    trim(substring(subformat, length(subformat) - strpos(reverse(subformat), '|')+2)) as content_data
  from base
  group by
    trim(substring(subformat, length(subformat) - strpos(reverse(subformat), '|')+2))
)
select
  content_type,
  content_data
from data
order by 
  content_type, 
  content_data
;
